/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SimpleRuleStore
extends ContextAwareBase
implements RuleStore {
    static String ANY = "*";
    HashMap<Pattern, List<Action>> rules = new HashMap();

    public SimpleRuleStore(Context context) {
        this.setContext(context);
    }

    public void addRule(Pattern pattern, Action action2) {
        action2.setContext(this.context);
        List<Action> a4p = this.rules.get(pattern);
        if (a4p == null) {
            a4p = new ArrayList<Action>();
            this.rules.put(pattern, a4p);
        }
        a4p.add(action2);
    }

    public void addRule(Pattern pattern, String actionClassName) {
        Action action2 = null;
        try {
            action2 = (Action)OptionHelper.instantiateByClassName(actionClassName, Action.class, this.context);
        }
        catch (Exception e) {
            this.addError("Could not instantiate class [" + actionClassName + "]", e);
        }
        if (action2 != null) {
            this.addRule(pattern, action2);
        }
    }

    public List matchActions(Pattern currentPattern) {
        List actionList = this.rules.get(currentPattern);
        if (actionList != null) {
            return actionList;
        }
        actionList = this.tailMatch(currentPattern);
        if (actionList != null) {
            return actionList;
        }
        actionList = this.prefixMatch(currentPattern);
        if (actionList != null) {
            return actionList;
        }
        actionList = this.middleMatch(currentPattern);
        if (actionList != null) {
            return actionList;
        }
        return null;
    }

    List tailMatch(Pattern currentPattern) {
        int max2 = 0;
        Pattern longestMatchingPattern = null;
        for (Pattern p : this.rules.keySet()) {
            int r;
            if (p.size() <= 1 || !p.get(0).equals(ANY) || (r = currentPattern.getTailMatchLength(p)) <= max2) continue;
            max2 = r;
            longestMatchingPattern = p;
        }
        if (longestMatchingPattern != null) {
            return this.rules.get(longestMatchingPattern);
        }
        return null;
    }

    List prefixMatch(Pattern currentPattern) {
        int max2 = 0;
        Pattern longestMatchingPattern = null;
        for (Pattern p : this.rules.keySet()) {
            int r;
            String last2 = p.peekLast();
            if (!ANY.equals(last2) || (r = currentPattern.getPrefixMatchLength(p)) != p.size() - 1 || r <= max2) continue;
            max2 = r;
            longestMatchingPattern = p;
        }
        if (longestMatchingPattern != null) {
            return this.rules.get(longestMatchingPattern);
        }
        return null;
    }

    List middleMatch(Pattern currentPattern) {
        int max2 = 0;
        Pattern longestMatchingPattern = null;
        for (Pattern p : this.rules.keySet()) {
            String last2 = p.peekLast();
            String first = null;
            if (p.size() > 1) {
                first = p.get(0);
            }
            if (!ANY.equals(last2) || !ANY.equals(first)) continue;
            List<String> partList = p.getCopyOfPartList();
            if (partList.size() > 2) {
                partList.remove(0);
                partList.remove(partList.size() - 1);
            }
            int r = 0;
            Pattern clone2 = new Pattern(partList);
            if (currentPattern.isContained(clone2)) {
                r = clone2.size();
            }
            if (r <= max2) continue;
            max2 = r;
            longestMatchingPattern = p;
        }
        if (longestMatchingPattern != null) {
            return this.rules.get(longestMatchingPattern);
        }
        return null;
    }

    public String toString() {
        String TAB = "  ";
        StringBuilder retValue = new StringBuilder();
        retValue.append("SimpleRuleStore ( ").append("rules = ").append(this.rules).append("  ").append(" )");
        return retValue.toString();
    }
}

